/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa;

import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.pa.PAAddRemoveCubesPanel;
import filenet.vw.apps.taskman.pa.PACubeListItem;
import filenet.vw.apps.taskman.pa.PADataFieldNode;
import filenet.vw.apps.taskman.pa.PADataFieldWizard;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import filenet.vw.apps.taskman.toolkit.dialog.IVWTaskWizardControl;
import filenet.vw.apps.taskman.toolkit.dialog.IVWTaskWizardPanel;
import filenet.vw.toolkit.utils.IVWListUpdateListener;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;

class PADataFieldCubesPanel
extends VWTaskTabPanel
implements IVWTaskWizardPanel,
IVWTaskWizardControl,
IVWListUpdateListener {
    PADataFieldWizard m_wizard = null;
    PADataFieldNode m_dataFieldNode = null;
    PAAddRemoveCubesPanel m_addRemoveCubesPanel = null;
    VWToolbarBorder m_cubeOptionsPanel = null;
    VWToolbarBorder m_exposedInCubesBorderPanel = null;
    JPanel m_spacerPanel = null;
    boolean m_bIsMeasure = false;
    boolean m_bExposedToFactTablesOnly = false;

    public PADataFieldCubesPanel(PADataFieldWizard wizard) {
        this.m_wizard = wizard;
        this.m_bExposedToFactTablesOnly = this.m_wizard.isExposedToFactTablesOnly();
        this.initLayout();
        this.resetProperties();
    }

    public PADataFieldCubesPanel(PADataFieldNode node) {
        this.m_dataFieldNode = node;
        this.m_bExposedToFactTablesOnly = this.m_dataFieldNode.isExposedToFactTablesOnly();
        this.initLayout();
        this.resetProperties();
        VWTaskUtil.updateComponentOrientation(this);
    }

    public int getCubes() {
        return this.m_addRemoveCubesPanel.getCubes();
    }

    public int getCubeOptions() {
        int cubeOptions = this.m_addRemoveCubesPanel.getCubeOptions();
        if (this.isExposedToFactTablesOnly()) {
            cubeOptions |= 0x40;
        }
        return cubeOptions;
    }

    public void resetProperties() {
        int cubes = 0;
        int cubeOptions = 0;
        boolean listEditable = true;
        if (this.m_dataFieldNode != null) {
            cubes = this.m_dataFieldNode.getCubes();
            cubeOptions = this.m_dataFieldNode.getCubeOptions();
            listEditable = false;
            this.m_bIsMeasure = this.m_dataFieldNode.isMeasure();
        } else if (this.m_wizard != null) {
            if (!this.m_wizard.isNewDataField()) {
                PADataFieldNode dataField = this.m_wizard.getDataFieldNode();
                cubes = dataField.getCubes();
                cubeOptions = dataField.getCubeOptions();
            }
            this.m_bIsMeasure = this.m_wizard.isMeasure();
        }
        this.m_addRemoveCubesPanel.initializeLists(cubes, cubeOptions, listEditable);
        this.refreshOptionPanel();
    }

    public boolean isExposedToFactTablesOnly() {
        return this.m_bExposedToFactTablesOnly;
    }

    public void performValidation() throws Exception {
        this.m_addRemoveCubesPanel.performValidation();
    }

    public String getInstructions() {
        if (this.isExposedToFactTablesOnly()) {
            return VWResource.SelectFactTablesToExposeDataField;
        }
        return VWResource.SelectCubesToExposeDataField;
    }

    public String getHelpPath() {
        return VWHelp.Help_Process_TaskManager + "pa_data_fields.htm";
    }

    public void refresh() {
        if (this.m_wizard != null) {
            boolean needsReset = false;
            if (this.m_wizard.isMeasure() != this.m_bIsMeasure) {
                needsReset = true;
            } else if (this.m_wizard.isExposedToFactTablesOnly() != this.m_bExposedToFactTablesOnly) {
                needsReset = true;
            }
            this.m_bIsMeasure = this.m_wizard.isMeasure();
            this.m_bExposedToFactTablesOnly = this.m_wizard.isExposedToFactTablesOnly();
            if (needsReset) {
                this.resetProperties();
            }
        }
        this.refreshOptionPanel();
        String title = this.isExposedToFactTablesOnly() ? VWResource.ExposeInFactTables : VWResource.ExposeInCubes;
        this.m_exposedInCubesBorderPanel.setTitle(title);
    }

    public boolean allowButtonToBeEnabled(int button) {
        if (button == 2) {
            Object[] items = this.m_addRemoveCubesPanel.getSelectedItems();
            return items != null && items.length > 0;
        }
        return true;
    }

    public void listUpdated(Object source, int nEventType, Object[] items) {
        if (nEventType == 6) {
            this.refreshOptionPanel(items);
        } else if (nEventType == 5) {
            this.refreshOptionPanel(null);
        }
        if (this.m_wizard != null) {
            this.m_wizard.updateButtonState();
        }
    }

    private void initLayout() {
        this.m_addRemoveCubesPanel = new PAAddRemoveCubesPanel(this.m_wizard, this);
        this.m_addRemoveCubesPanel.addListUpdateListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.getExposeInCubesPanel(), c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_spacerPanel = new JPanel();
        this.add((Component)this.m_spacerPanel, c);
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_cubeOptionsPanel = this.getCubeOptionsPanel();
        this.add((Component)this.m_cubeOptionsPanel, c);
        this.m_cubeOptionsPanel.setVisible(false);
    }

    private JPanel getExposeInCubesPanel() {
        this.m_exposedInCubesBorderPanel = new VWToolbarBorder("", 0);
        JPanel panel = this.m_exposedInCubesBorderPanel.getClientPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 10, 0, 10);
        panel.add((Component)this.m_addRemoveCubesPanel, c);
        return this.m_exposedInCubesBorderPanel;
    }

    private VWToolbarBorder getCubeOptionsPanel() {
        VWToolbarBorder borderPanel = new VWToolbarBorder(VWResource.CubeOptions, 0);
        JPanel panel = borderPanel.getClientPanel();
        panel.setLayout(new GridBagLayout());
        return borderPanel;
    }

    private void refreshOptionPanel() {
        this.refreshOptionPanel(this.m_addRemoveCubesPanel.getSelectedItemsInSelectedList());
    }

    private void refreshOptionPanel(Object[] selectedItems) {
        PACubeListItem selectedCube;
        PACubeListItem pACubeListItem = selectedCube = selectedItems != null && selectedItems.length > 0 ? (PACubeListItem)selectedItems[0] : null;
        if (this.m_bIsMeasure && selectedCube != null && selectedCube.getOptionsPanel() != null) {
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 23;
            c.fill = 1;
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(10, 10, 10, 10);
            this.m_cubeOptionsPanel.getClientPanel().removeAll();
            this.m_cubeOptionsPanel.getClientPanel().add((Component)selectedCube.getOptionsPanel(), c);
            this.m_cubeOptionsPanel.setVisible(true);
            this.m_spacerPanel.setVisible(false);
            this.m_cubeOptionsPanel.invalidate();
            this.m_cubeOptionsPanel.validate();
            this.m_cubeOptionsPanel.repaint();
        } else {
            this.m_spacerPanel.setVisible(true);
            this.m_cubeOptionsPanel.setVisible(false);
        }
    }

    public boolean skipThisPanel() {
        return false;
    }
}

